; App.s : AvP[V
;



; W[錾
;
    .module App


; Qƃt@C
;
    .include    "bios.inc"
    .include    "vdp.inc"
    .include    "System.inc"
    .include	"App.inc"
    .include    "Back.inc"
    .include    "Title.inc"
    .include    "Game.inc"


; Oϐ錾
;
    .globl  _pattern



; CODE ̈
;
    .area   _CODE


; AvP[V
;
_AppInitialize::
    
    ; WX^̕ۑ
    push    hl
    push    bc
    push    ix
    
    ; XN[[h̐ݒ
    ld      a, #VIDEO_GRAPHIC1
    call    _SystemSetScreenMode
    
    ; 荞݂̋֎~
    di
    
    ; p^[WFl[^̓]
    ld      a, (_videoPort + 1)
    inc     a
    ld      c, a
    ld      a, #<VIDEO_GRAPHIC1_PATTERN_GENERATOR_TABLE
    out     (c), a
    ld      a, #(>VIDEO_GRAPHIC1_PATTERN_GENERATOR_TABLE | 0b01000000)
    out     (c), a
    dec     c
    ld      hl, #(_pattern + 0x0000)
    ld      b, #0x00
    otir
    otir
    otir
    otir
    otir
    otir
    otir
    otir
    
    ; XvCgWFl[^̓]
    inc     c
    ld      a, #<VIDEO_GRAPHIC1_SPRITE_GENERATOR_TABLE
    out     (c), a
    ld      a, #(>VIDEO_GRAPHIC1_SPRITE_GENERATOR_TABLE | 0b01000000)
    out     (c), a
    dec     c
    otir
    otir
    otir
    otir
    otir
    otir
    otir
    otir
    
    ; 荞݋֎~̉
    ei
    
    ; AvP[V̏
    
    ; nCXRȀ
    ld      ix, #_appHiscore
    xor     a
    ld      0(ix), a
    ld      1(ix), a
    ld      3(ix), a
    ld      4(ix), a
    ld      5(ix), a
    ld      a, #0x05
    ld      2(ix), a
    
    ; ݂̃XRȀ
    ld      ix, #_appScore
    xor     a
    ld      0(ix), a
    ld      1(ix), a
    ld      2(ix), a
    ld      3(ix), a
    ld      4(ix), a
    ld      5(ix), a
    
    ; XRA̔{̏
    ld      ix, #_appRate
    xor     a
    ld      0(ix), a
    ld      2(ix), a
    ld      3(ix), a
    inc     a
    ld      1(ix), a
    
    ; ^C}̏
    ld      ix, #_appTimer
    xor     a
    ld      0(ix), a
    ld      1(ix), a
    ld      2(ix), a
    ld      3(ix), a
    
    ; [h̏
    ld      a, #APP_MODE_LOAD
    ld      (_appMode), a
    
    ; Ԃ̍XV
    ld      a, #APP_STATE_NULL
    ld      (_appState), a
    ld      a, #APP_PHASE_NULL
    ld      (_appPhase), a
    
    ; WX^̕A
    pop     ix
    pop     bc
    pop     hl
    
    ; I
    ret


; AvP[VXV
;
_AppUpdate::
    
    ; WX^̕ۑ
    push    hl
    push    bc
    push    de
    push    ix
    push    iy
    
    ; [h̎擾
    ld      a, (_appMode)
    
    ; ǂݍ
    cp      #APP_MODE_LOAD
    jr      nz, 00$
    call    AppLoad
    jr      AppUpdateEnd
00$:
    
    ; ^Cg
    cp      #APP_MODE_TITLE
    jr      nz, 01$
    call    AppTitle
    jr      AppUpdateEnd
01$:
    
    ; Q[
    cp      #APP_MODE_GAME
    jr      nz, 02$
    call    AppGame
    jr      AppUpdateEnd
02$:
    
    ; XV̏I
AppUpdateEnd:
    
    ; ܂킷
    call    _SystemGetRandom
    
    ; WX^̕A
    pop     iy
    pop     ix
    pop     de
    pop     bc
    pop     hl
    
    ; I
    ret


; AvP[Vǂݍ
;
AppLoad:
    
    ; wĩ[h
    call    _BackLoad
    
    ; wiF̐ݒ
    ld      a, #0x07
    ld      (_videoRegister + VDP_R7), a
    
    ; XvCg̐ݒƕ\̊Jn
    ; ld      hl, #(_videoRegister + VDP_R1)
    ; ld      a, (hl)
    ; or      #((1 << VDP_R1_BL) | (1 << VDP_R1_SI))
    ; ld      (hl), a
    ld      hl, #(_videoRegister + VDP_R1)
    set     #VDP_R1_BL, (hl)
    set     #VDP_R1_SI, (hl)
    
    ; V-Blank ̓]̊Jn
    ld      hl, #_request
    set     #REQUEST_VIDEO_REGISTER, (hl)
    
    ; [h̍XV
    ld      a, #APP_MODE_TITLE
    ld      (_appMode), a
    
    ; Ԃ̍XV
    ld      a, #APP_STATE_NULL
    ld      (_appState), a
    ld      a, #APP_PHASE_NULL
    ld      (_appPhase), a
    
    ; I
    ret


; ^Cgʂ
;
AppTitle:
    
    ; ^Cgʂ̍XV
    call    _TitleUpdate
    
    ; I
    ret


; Q[ʂ
;
AppGame:
    
    ; Q[ʂ̍XV
    call    _GameUpdate
    
    ; I
    ret



; 萔̒`
;



; DATA ̈
;
    .area   _DATA


; ϐ̒`
;

; [h
;
_appMode::
    
    .ds     1

; 
;
_appState::
    
    .ds     1

_appPhase::
    
    .ds     1

; nCXRA
;
_appHiscore::
    
    .ds     6

; ݂̃XRA
;
_appScore::
    
    .ds     6

; XRA̔{
;
_appRate::
    
    .ds     4

; ^C}
;
_appTimer::
    
    .ds     4



